﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

namespace GE.Gui
{
    /// <summary>
    /// Represents a node in the button navigation map.
    /// </summary>
    class ButtonNode
    {
        /// <summary>
        /// Button.
        /// </summary>
        private WButton m_button;

        /// <summary>
        /// Button on the left.
        /// </summary>
        private WButton m_left;

        /// <summary>
        /// Button on the right.
        /// </summary>
        private WButton m_right;

        /// <summary>
        /// Button on the top.
        /// </summary>
        private WButton m_top;

        /// <summary>
        /// Button on the bottom.
        /// </summary>
        private WButton m_bottom;

        /// <summary>
        /// Button.
        /// </summary>
        public WButton Button
        {
            get
            {
                return m_button;
            }
            set
            {
                m_button = value;
            }
        }

        /// <summary>
        /// Button on the left.
        /// </summary>
        public WButton Left
        {
            get
            {
                return m_left;
            }
            set
            {
                m_left = value;
            }
        }

        /// <summary>
        /// Button on the right.
        /// </summary>
        public WButton Right
        {
            get
            {
                return m_right;
            }
            set
            {
                m_right = value;
            }
        }

        /// <summary>
        /// Button on the top.
        /// </summary>
        public WButton Top
        {
            get
            {
                return m_top;
            }
            set
            {
                m_top = value;
            }
        }

        /// <summary>
        /// Button on the bottom.
        /// </summary>
        public WButton Bottom
        {
            get
            {
                return m_bottom;
            }
            set
            {
                m_bottom = value;
            }
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="button">button</param>
        /// <param name="left">button on the left</param>
        /// <param name="right">button on the right</param>
        /// <param name="top">button on the top</param>
        /// <param name="bottom">button on the bottom</param>
        public ButtonNode(WButton button, WButton left, WButton right,
            WButton top, WButton bottom)
        {
            m_button = button;
            m_left = left;
            m_right = right;
            m_top = top;
            m_bottom = bottom;
        }
    }
}
